package com.zthzinfo.contract.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
* @description /
* @author zhaoey
* @date 2021-12-14
**/
@Data
@TableName("ctrt_contract_clauses")
public class ContractClauses implements Serializable {


    @TableId
    @ApiModelProperty(value = "条款ID")
    private String id;

    @NotBlank
    @ApiModelProperty(value = "合同ID")
    private String contractId;

    @NotBlank
    @ApiModelProperty(value = "合同内容")
    private String content;

    @NotNull
    @ApiModelProperty(value = "是否标准合同条款")
    private Boolean standard;

    @ApiModelProperty(value = "合同模板条款ID")
    private String tplClauseId;

    @NotNull
    @ApiModelProperty(value = "是否允许修改")
    private Boolean enableChange;

    @ApiModelProperty(value = "条款项需要添加表格")
    private String showTable;

    @ApiModelProperty(value = "条款标题")
    private String contentTitle;
    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "修改时间")
    private Timestamp updateTime;

    @ApiModelProperty(value = "修改人")
    @TableField(fill = FieldFill.UPDATE)
    private String updateBy;

    @ApiModelProperty(value = "逻辑删除标志，0：正常，1：已删除")
    @TableLogic
    private Integer delFlag;

    @NotNull
    @ApiModelProperty(value = "条款类型，0：正常，1：头部，2：底部")
    private Integer clausesType;

    public void copy(ContractClauses source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}