package com.zthzinfo.contract.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* @description
 *
 * 状态解释：
 * status=0，sp_status=3 是拒绝
 * status=1,sp_status=2 是审批通过
 * status=0，sp_status=0 是审批中|未发起审批
 * status=0，sp_status=4 已撤回
 *
* @author zhaoey
* @date 2021-12-14
**/
@Data
@TableName("ctrt_contract")
public class CtrtContract implements Serializable {


    @TableId
    @ApiModelProperty(value = "合同ID")
    private String id;

//    @NotBlank(message = "合同号不能为空")
    @ApiModelProperty(value = "合同号")
    private String contractNo;

    @NotBlank(message = "合同标题不能为空")
    @ApiModelProperty(value = "合同标题")
    private String contractTitle;

    /**
     * 租户ID（可选）
     */
    private String tenantId;

    @ApiModelProperty(value = "签订日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @JsonSerialize(using = LocalDateSerializer.class)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDate signDate;

    @ApiModelProperty(value = "协商一致日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @JsonSerialize(using = LocalDateSerializer.class)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDate consensusDate;

//    @NotNull(message = "合同有效期不能为空")
    @ApiModelProperty(value = "有效期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @JsonSerialize(using = LocalDateSerializer.class)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDate validityDate;

    /**
     * @see com.zthzinfo.contract.enums.ContractTypeEnums
     */
    @NotNull(message = "合同类型不能为空")
    @ApiModelProperty(value = "合同类型")
    private Integer contractType;
    /**
     * @see com.zthzinfo.contract.enums.ContractModuleEnums
     */
    @NotNull(message = "合同模块不能为空")
    @ApiModelProperty(value = "合同模块")
    private Integer contractModule;

    @NotBlank(message = "甲方ID不能为空")
    @ApiModelProperty(value = "甲方ID")
    private String partyAId;

    @NotBlank(message = "甲方名称不能为空")
    @ApiModelProperty(value = "甲方名称")
    private String partyAName;

    @ApiModelProperty(value = "甲方开户行")
    private String partyADepositBank;

    @ApiModelProperty(value = "甲方银行账号")
    private String partyABankAccount;

    @ApiModelProperty(value = "甲方联系方式")
    private String partyAContact;

    @NotBlank(message = "乙方ID不能为空")
    @ApiModelProperty(value = "乙方ID")
    private String partyBId;

    @NotBlank(message = "乙方名称不能为空")
    @ApiModelProperty(value = "乙方名称")
    private String partyBName;

    @ApiModelProperty(value = "乙方开户行")
    private String partyBDepositBank;

    @ApiModelProperty(value = "乙方银行账号")
    private String partyBBankAccount;

    @ApiModelProperty(value = "乙方联系方式")
    private String partyBContact;

    @NotNull(message = "是否使用模板不能为空")
    @ApiModelProperty(value = "是否使用模板")
    private Boolean useTpl;

    @NotNull(message = "是否标准不能为空")
    @ApiModelProperty(value = "是否标准合同")
    private Boolean standard;

    @ApiModelProperty(value = "上传文件url")
    private String fileUrl;
    @ApiModelProperty(value = "上传文件名称")
    private String fileName;

    @ApiModelProperty(value = "审批预览的文件url")
    private String previewFileUrl;

    @ApiModelProperty(value = "签章后的文件url")
    private String signedFileUrl;
    @ApiModelProperty(value = "签章后的文件名称")
    private String signedFileName;

    @NotNull(message = "审批状态不能为空")
    @ApiModelProperty(value = "审批状态")
    private Integer spStatus;

    @ApiModelProperty(value = "条款表单schema")
    private String clausesForm;

    private String tplSchema;

    @ApiModelProperty(value = "模板ID")
    private String tplId;

    @ApiModelProperty(value = "合同创建的来源")
    private String source;

    /**
     * @see com.zthzinfo.contract.enums.ContractStatusEnums
     */
    @ApiModelProperty(value = "合同状态")
    private Integer status;

    @ApiModelProperty(value = "我是甲方")
    private Boolean myIsPartyA;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "修改人")
    @TableField(fill = FieldFill.UPDATE)
    private String updateBy;

    @ApiModelProperty(value = "逻辑删除标志，0：正常，1：已删除")
    @TableLogic
    private Integer delFlag;

    @ApiModelProperty(value = "第三方数据")
    private String processData;

    public void copy(CtrtContract source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}