package com.zthzinfo.contract.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * id生成 实体类
 *
 * @author zhaoey
 * @since 12/20/2021
 */
@Data
@TableName("ctrt_id_gen")
public class IdGen implements Serializable {
    private static final long serialVersionUID = 139773295717798844L;

    @TableId
    private String id;

    /** 集团及下属公司代码以公司名称大写字母编制，原则上不超过 6 个字母，一旦启用不得更改。例如： “上海成功和泰实业集团发展有限公司”为“SHCGHT”。 */
    private String companyCode;
    /** 合同经办部门代码以经办部门英文的大写首字母表示，例如： 法务部：LD;行政部：AD。 */
    private String deptCode;
    /** 合同类型代码 */
    private String typeCode;

    /**
     * 租户ID（可选）
     */
    private String tenantId;

    /**
     * 当年的业务量
     */
    private Integer businessCount;
    @TableField(fill = FieldFill.INSERT)
    private String createBy;
    private Date createTime;
    @TableField(fill = FieldFill.UPDATE)
    private String updateBy;
    private Date updateTime;
    @TableLogic
    private Integer delFlag;

}
