package com.zthzinfo.contract.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
* @description /
* @author zhaoey
* @date 2021-12-14
**/
@Data
@TableName("ctrt_tpl_contract")
public class TplContract implements Serializable {


    @TableId
    @ApiModelProperty(value = "模板ID")
    private String id;

    @ApiModelProperty(value = "表单schema")
    private String formSchema;

    /**
     * 租户ID（可选）
     */
    private String tenantId;

    /**
     * @see com.zthzinfo.contract.enums.ContractModuleEnums
     */
    @NotNull
    @ApiModelProperty(value = "模块")
    private Integer module;

    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "修改时间")
    private Timestamp updateTime;

    @ApiModelProperty(value = "修改人")
    @TableField(fill = FieldFill.UPDATE)
    private String updateBy;

    @ApiModelProperty(value = "逻辑删除标志，0：正常，1：已删除")
    @TableLogic
    private Integer delFlag;

    @NotBlank
    @ApiModelProperty(value = "合同模板名称")
    private String name;
    /**
     * @see com.zthzinfo.contract.enums.ContractTypeEnums
     */
    @NotBlank
    @ApiModelProperty(value = "合同类型")
    private Integer contractType;

    @NotNull
    @ApiModelProperty(value = "是否使用模板")
    private Boolean useTpl;

    public void copy(TplContract source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}