package com.zthzinfo.contract.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同类型
 *
 * @author zhaoey
 * @since 2021/12/15
 */
@Getter
@AllArgsConstructor
public enum ContractTypeEnums {
    /** 钢材物流（成功物流） */
    GANGCAI_ZC(1,"航次租船合同","Z"),
    GANGCAI_PH(2,"航次运输合同","P"),
    GANGCAI_NZC(3,"内部租船合同","Z(N)"),
    GANGCAI_GB(4,"航次过驳合同","GB"),
    GANGCAI_YS(5,"运输协议（长期）","CX"),
    SANHUO_CHENGZU_YUNSHU(10,"航次租船合同","Z"),
    SANHUO_CHUZU_YUNSHU(11,"航次配货合同","P"),
    SHOUTUOREN_SHIP_PROXY(20,"受托人船舶代理合同","CD(S)"),
    WEITUOREN_SHIP_PROXY(21,"委托人船舶代理合同","CD(W)"),
    SHOUTUOREN_GOODS_PROXY(22,"受托人货运代理协议","HD(S)"),
    WEITUOREN_GOODS_PROXY(23,"委托人货运代理协议","HD(W)"),
    OTHER(99,"其他","QT"),
    ;

    private final int key;
    private final String name;
    private final String code;


    public static String parseName(Integer key) {
        if (key == null) {
            return null;
        }
        for (ContractTypeEnums value : values()) {
            if(value.key == key) {
                return value.name;
            }
        }
        return null;
    }
    public static ContractTypeEnums parse(Integer key) {
        if (key == null) {
            return null;
        }
        for (ContractTypeEnums value : values()) {
            if(value.key == key) {
                return value;
            }
        }
        return null;
    }

}
