package com.zthzinfo.contract.enums;

public enum ProcessStatusEnum {
    SPING(1,"审批中")
    ,AGREE(2,"审核通过")
    ,REJECT(3,"审核拒绝")
    ,CANCEL(4,"已撤回")
    ,RESUBMIT(5,"已重新提交")
    ;

    private final int key;
    private final String desc;

    ProcessStatusEnum(int key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static String getDescByKey(int key){
        for (ProcessStatusEnum value : ProcessStatusEnum.values()) {
            if (value.getKey() == key){
                return value.getDesc();
            }
        }
        return null;
    }

    public int getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }
}
