package com.zthzinfo.contract.handler.dispatcher;

import com.zthzinfo.contract.handler.IContractFileExchange;
import com.zthzinfo.contract.model.dto.FileParams;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 分发器-分享PDF
 * @author zhaoeryu
 * @since 2021/9/13
 */
@Component
public class ContractFileDispatcher implements ApplicationContextAware {

    private Collection<IContractFileExchange> exchanges;

    public String dispatch(FileParams params) {
        for (IContractFileExchange exchange : exchanges) {
            if (exchange.support(params.getContractType())) {
                return exchange.exchange(params);
            }
        }
        throw new IllegalArgumentException(String.format("[%s]没有匹配的处理器",params.getModule()));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.exchanges = applicationContext.getBeansOfType(IContractFileExchange.class).values();
    }
}
