package com.zthzinfo.contract.handler.dispatcher;

import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.handler.IContractProcessGetChartererExchange;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 合同审批流程获取租船人处理分发
 *
 * @author zhaoeryu
 * @since 2022/8/15
 */
@Component
public class ContractProcessGetChartererDispatcher implements ApplicationContextAware {

    private Collection<IContractProcessGetChartererExchange> exchanges;

    public String dispatch(CtrtContract params) {
        for (IContractProcessGetChartererExchange exchange : exchanges) {
            if (exchange.support(params.getSource())) {
                return exchange.exchange(params);
            }
        }
        throw new IllegalArgumentException(String.format("[%s]没有匹配的处理器", params.getSource()));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.exchanges = applicationContext.getBeansOfType(IContractProcessGetChartererExchange.class).values();
    }
}
