package com.zthzinfo.contract.handler.dispatcher;

import com.zthzinfo.contract.handler.IContractProcessStatusExchange;
import com.zthzinfo.contract.model.dto.ContractProcessStatusParams;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 合同审批流程状态处理分发
 *
 * @author zhaoeryu
 * @since 2022/8/15
 */
@Component
public class ContractProcessStatusDispatcher implements ApplicationContextAware {

    private Collection<IContractProcessStatusExchange> exchanges;

    @Async
    public void dispatch(ContractProcessStatusParams params) {
        for (IContractProcessStatusExchange exchange : exchanges) {
            if (exchange.support(params.getSource())) {
                exchange.exchange(params);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("[%s]没有匹配的处理器", params.getSource()));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.exchanges = applicationContext.getBeansOfType(IContractProcessStatusExchange.class).values();
    }
}
