package com.zthzinfo.contract.handler.exchange;

import com.zthzinfo.contract.enums.ContractSourceEnums;
import com.zthzinfo.contract.handler.IContractProcessStatusExchange;
import com.zthzinfo.contract.model.dto.ContractProcessStatusParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 财务系统审批流程状态
 *
 * @author zhaoeryu
 * @since 2022/8/15
 */
@Slf4j
@Component
public class CaiwuContractProcessStatusExchange implements IContractProcessStatusExchange {

    @Override
    public boolean support(String source) {
        return ContractSourceEnums.CAIWU.getValue().equals(source);
    }

    @Override
    public void exchange(ContractProcessStatusParams params) {
        log.info("[合同审批完成-财务系统]contractId={},spStatus={}",params.getContractId(), params.getSpStatus());
    }
}
