package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.enums.ContractSourceEnums;
import com.zthzinfo.contract.handler.IContractProcessGetChartererExchange;
import com.zthzinfo.contract.service.CtrtContractService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 钢材业务系统审批流程获取租船人
 *
 * @author zhaoeryu
 * @since 2022/8/15
 */
@Slf4j
@Component
public class GangcaiContractProcessGetChartererExchange implements IContractProcessGetChartererExchange {

    @Resource
    CtrtContractService ctrtContractService;

    @Override
    public boolean support(String source) {
        return ContractSourceEnums.GANGCAI.getValue().equals(source);
    }

    @Override
    public String exchange(CtrtContract contract) {
        log.info("[GetCharterer]获取租船人");
        Assert.notBlank(contract.getProcessData(), "[GetCharterer]回调参数为空，不进行处理");
        JSONObject processData = JSONObject.parseObject(contract.getProcessData());
        String shipLineId = processData.getString("id");
        Assert.notBlank(shipLineId,"[GetCharterer]未解析出shipLineId，不进行处理");
        return null;
//        Map<String, Object> resp = shipLineClient.getChartererWxUserIdByShipLineId(shipLineId);
//        if (resp == null || !resp.containsKey("data")){
//            throw new AlertException("[GetCharterer]未获取到租船人WxUserId");
//        }
//        String wxUserId = resp.get("data").toString();
//        Assert.notBlank(wxUserId, "[GetCharterer]租船员WxUserId为空");
//        SysUser user = userService.getUserByWxUserId(wxUserId);
//        return Optional.ofNullable(user).map(SysUser::getUserId).orElse(null);
    }
}
