package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.enums.ContractSourceEnums;
import com.zthzinfo.contract.handler.IContractProcessStatusExchange;
import com.zthzinfo.contract.model.dto.ContractProcessStatusParams;
import com.zthzinfo.contract.service.CtrtContractService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 钢材业务系统审批流程状态
 *
 * @author zhaoeryu
 * @since 2022/8/15
 */
@Slf4j
@Component
public class GangcaiContractProcessStatusExchange implements IContractProcessStatusExchange {

    @Resource
    CtrtContractService ctrtContractService;

    @Override
    public boolean support(String source) {
        return ContractSourceEnums.GANGCAI.getValue().equals(source);
    }

    @Override
    public void exchange(ContractProcessStatusParams params) {
        log.info("[通知钢材业务系统]contractId={},spStatus={}",params.getContractId(), params.getSpStatus());
        CtrtContract contract = ctrtContractService.getById(params.getContractId());
        Assert.notNull(contract);
        if (StrUtil.isBlank(contract.getProcessData())) {
            log.warn("[通知钢材业务系统]回调参数为空，不进行处理");
            return;
        }
        JSONObject processData = null;
        try {
            processData = JSONObject.parseObject(contract.getProcessData());
        } catch (Exception e) {
            log.error("[通知钢材业务系统]解析processData异常，不进行处理");
            e.printStackTrace();
            throw e;
        }
        String shipLineId = processData.getString("id");
        if (StrUtil.isBlank(shipLineId)) {
            log.error("[通知钢材业务系统]未解析出shipLineId，不进行处理");
        }
//        shipLineClient.updateContractStatus(shipLineId, params.getSpStatus());
    }
}
