package com.zthzinfo.contract.interfaceapi;

import com.zthzinfo.contract.interfaceapi.vo.CtrtAccountDto;
import com.zthzinfo.contract.interfaceapi.vo.CtrtCompanyDto;
import com.zthzinfo.contract.interfaceapi.vo.CtrtContactDto;
import com.zthzinfo.contract.interfaceapi.vo.CtrtPageDto;

import java.util.List;

public interface IContractDataProvider {

    /**
     * 分页查询公司列表，用于用户选择一个公司
     * @param page
     * @param size
     * @param keyword
     * @param searchForRole 用作合同签署方的角色（甲方、乙方）
     * @param currentRole 当前用户承担的的角色（甲方、乙方）
     * @return
     */
    CtrtPageDto<CtrtCompanyDto> listCompanyForChoose(Integer page,
                                                     Integer size,
                                                     String keyword,
                                                     String searchForRole,
                                                     String currentRole);


    /**
     * 根据公司id获取账户列表，让用户选择一个
     * @param id 公司id
     * @param searchForRole 用作合同签署方的角色（甲方、乙方）
     * @param currentRole 当前用户承担的的角色（甲方、乙方）
     * @return
     */
    List<CtrtAccountDto> accountList(String id, String searchForRole, String currentRole);

    /**
     * 根据公司id分别获取一个联系人
     * @param companyIdA 甲方公司id
     * @param companyIdB 乙方公司id
     * @param currentRole 当前用户承担的的角色（甲方、乙方）
     * @return
     */
    CtrtContactDto[] getContactByCompanyId(String companyIdA, String companyIdB, String currentRole);

    /**
     * 根据客户id获取联系人列表，让用户选择一个联系人
     * @param customerId 客户id
     * @param searchForRole 用作合同签署方的角色（甲方、乙方）
     * @param currentRole 当前用户承担的的角色（甲方、乙方）
     * @return
     */
    List<CtrtContactDto> contactByCustomerId(String customerId, String searchForRole, String currentRole);
}
