package com.zthzinfo.contract.model.dto;

import lombok.Data;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Data
public class ContractClausesFormDTO {
    private String shipName;
    private String deadWeight;
    private String shipLengthHeightWidth;
    private String registerPort;
    private String ton;
    private String heavyDraft;
    private String buildTime;
    private String hatchVolume;
    private String lightDraft;
    private String voyage;
    private String derrickNumber;
    private String hatchCount;
    private String startPort;
    private String endPort;
    private String calcUnit;
    private String planLoadingDate;
    private String arrivalDate;
    private String deposit;
    private LocalDate depositPayTime;
    private String demurrageRate;
    private String goodsName;
    private String goodsWeight;
    private String quantity;
    private String pack;
    private String bulkVolume;
    private String freightRate;
    private String invoiceType;
    private String loadGoodsTime;
    private String unLoadGoodsTime;
    private String loadPortInstallation; // 港装
    private String unPortCargo; // 港卸
    private String endFinishDay;
    private String payeeName;
    private String payeeBankAccount;
    private String payeeAccount;
    private String leaseeFaxno;
    private String leaseeEmail;
    private String leaserFaxno;
    private String leaserEmail;
    private String leaseeWechatName;
    private String leaseeWechatID;
    private String leaserWechatName;
    private String leaserWechatID;
    private String leaseeContact;
    private String leaserContact;
    private String longestDemurrage;
    private List<ShipPrice> shipPriceList=new ArrayList<>();

    @Data
    public static class ShipPrice {
        private String goodsName;
        private String goodsWeight;
        private String quantity;
        private String pack;
        private String bulkVolume;
        private String freightRate;
        private String invoiceType;
        private String longestDemurrage;
    }
}
