package com.zthzinfo.contract.model.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoeryu
 * @since 2021/9/13
 */
@Data
public class FileParams {

    /**
     * image 、 pdf
     */
    @NotBlank(message = "文件类型不能为空")
    private String type;
    /**
     * ShareModuleEnums
     */
    @NotNull(message = "模块不能为空")
    private String module;
    @NotNull(message = "合同类型不能为空")
    private Integer contractType;

    /** 是否生成长图 */
    private boolean genLongImageFile = false;
    /** BusinessShare.Id */
    private String id;

    private boolean useData;
    private Object data;

    /**
     * 是否区分标准合同
     * true: 非标条款会特殊颜色标识
     * false: 非标条款不进行处理
     */
    private boolean diffStandard;

    public <T> T dataToT() {
        if(this.data != null) {
            return (T) this.data;
        }
        return null;
    }
}
