package com.zthzinfo.contract.service;

import com.zthzinfo.contract.base.BaseService;
import com.zthzinfo.contract.domain.ContractChangeStatusLog;
import com.zthzinfo.contract.model.dto.ContractChangeStatusLogQueryCriteria;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * 合同状态变更记录表(ContractChangeStatusLog)表服务接口
 *
 * @author zhaoey
 * @since 2022-01-27 10:46:45
 */
public interface CtrtContractChangeStatusLogService extends BaseService<ContractChangeStatusLog> {

    /**
     * 查询数据分页
     *
     * @param criteria 查询条件
     * @param pageable 分页参数
     * @return Map<String, Object>
     */
    Map<String, Object> queryAll(ContractChangeStatusLogQueryCriteria criteria, Pageable pageable);

    /**
     * 查询所有数据不分页
     *
     * @param criteria 查询条件
     * @return List<ContractChangeStatusLog>
     */
    List<ContractChangeStatusLog> queryAll(ContractChangeStatusLogQueryCriteria criteria);


}
