package com.zthzinfo.contract.service;

import com.zthzinfo.contract.base.BaseService;
import com.zthzinfo.contract.domain.ContractClauses;
import com.zthzinfo.contract.service.dto.ContractClausesDto;
import com.zthzinfo.contract.service.dto.ContractClausesQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
* @description 服务接口
* @author zhaoey
* @date 2021-12-14
**/
public interface CtrtContractClausesService extends BaseService<ContractClauses> {

    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return Map<String,Object>
    */
    Map<String,Object> queryAll(ContractClausesQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<ContractClausesDto>
    */
    List<ContractClausesDto> queryAll(ContractClausesQueryCriteria criteria);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<ContractClausesDto> all, HttpServletResponse response) throws IOException;
}