package com.zthzinfo.contract.service;

import com.github.pagehelper.PageInfo;
import com.zthzinfo.contract.base.BaseService;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.model.dto.ContractDTO;
import com.zthzinfo.contract.service.dto.ContractDto;
import com.zthzinfo.contract.service.dto.CtrtContractQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
* @description 服务接口
* @author zhaoey
* @date 2021-12-14
**/
public interface CtrtContractService extends BaseService<CtrtContract> {

    /**
     * 查询数据分页
     * @param criteria 条件
     * @param pageable 分页参数
     * @return Map<String,Object>
     */
    Map<String,Object> queryAll(CtrtContractQueryCriteria criteria, Pageable pageable);

    /**
     * 查询所有数据不分页
     * @param criteria 条件参数
     * @return List<ContractDto>
     */
    List<ContractDto> queryAll(CtrtContractQueryCriteria criteria);


    ContractDTO selectById(String id);
    ContractDTO selectClausesByTplId(String tplId);
    void saveEntity(ContractDTO res);

    void download(List<ContractDto> list, HttpServletResponse response) throws IOException;

    String updateSignDate(ContractDTO res);

    PageInfo<ContractDto> searchContract(CtrtContractQueryCriteria criteria, Pageable pageable);

}