package com.zthzinfo.contract.service;

import com.zthzinfo.contract.base.BaseService;
import com.zthzinfo.contract.domain.TplContractClauses;
import com.zthzinfo.contract.service.dto.TplContractClausesDto;
import com.zthzinfo.contract.service.dto.TplContractClausesQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
* @description 服务接口
* @author zhaoey
* @date 2021-12-14
**/
public interface CtrtTplContractClausesService extends BaseService<TplContractClauses> {

    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return Map<String,Object>
    */
    Map<String,Object> queryAll(TplContractClausesQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<TplContractClausesDto>
    */
    List<TplContractClausesDto> queryAll(TplContractClausesQueryCriteria criteria);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<TplContractClausesDto> all, HttpServletResponse response) throws IOException;
}