package com.zthzinfo.contract.service;

import com.zthzinfo.contract.base.BaseService;
import com.zthzinfo.contract.domain.TplContract;
import com.zthzinfo.contract.service.dto.TplContractDto;
import com.zthzinfo.contract.service.dto.TplContractQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
* @description 服务接口
* @author zhaoey
* @date 2021-12-14
**/
public interface CtrtTplContractService extends BaseService<TplContract> {

    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return Map<String,Object>
    */
    Map<String,Object> queryAll(TplContractQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<TplContractDto>
    */
    List<TplContractDto> queryAll(TplContractQueryCriteria criteria);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<TplContractDto> all, HttpServletResponse response) throws IOException;
}