/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package com.zthzinfo.contract.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author zhaoey
* @date 2021-12-14
**/
@Data
public class ContractClausesDto implements Serializable {

    /** 条款ID */
    private String id;

    /** 合同ID */
    private String contractId;

    /** 合同内容 */
    private String content;

    /** 是否标准合同条款 */
    private Boolean standard;

    /** 合同模板条款ID */
    private String tplClaueseId;

    /** 是否允许修改 */
    private Boolean enableChange;

    /** 条款项需要添加表格 */
    private String showTable;

    /** 条款标题 */
    private String contentTitle;

    private Integer sort;

    /** 创建时间 */
    private Timestamp createTime;

    /** 创建人 */
    private String createBy;

    /** 修改时间 */
    private Timestamp updateTime;

    /** 修改人 */
    private String updateBy;

    /** 逻辑删除标志，0：正常，1：已删除 */
    private Integer delFlag;

    /** 条款类型，0：正常，1：头部，2：底部 */
    private Integer clausesType;
}