package com.zthzinfo.contract.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @website https://el-admin.vip
 * @description /
 * @author zhaoey
 * @date 2021-12-28
 **/
@Data
public class ContractDto implements Serializable {

    /** 合同ID */
    private String id;

    /** 合同号 */
    private String contractNo;

    /** 合同标题 */
    private String contractTitle;

    /** 签订日期 */
    private LocalDateTime signDate;

    /** 协商一致日期 */
    private LocalDate consensusDate;

    /** 有效期 */
    private LocalDateTime validityDate;

    /** 合同类型 */
    private Integer contractType;

    /** 甲方ID */
    private String partyAId;

    /** 甲方名称 */
    private String partyAName;

    /** 甲方开户行 */
    private String partyADepositBank;

    /** 甲方银行账号 */
    private String partyABankAccount;

    /** 甲方联系方式 */
    private String partyAContact;

    /** 乙方ID */
    private String partyBId;

    /** 乙方名称 */
    private String partyBName;

    /** 乙方开户行 */
    private String partyBDepositBank;

    /** 乙方银行账号 */
    private String partyBBankAccount;

    /** 乙方联系方式 */
    private String partyBContact;

    /** 是否使用模板 */
    private Boolean useTpl;

    /** 是否标准合同 */
    private Boolean standard;

    /** 文件url */
    private String fileUrl;

    /** 签章后的文件url */
    private String signedFileUrl;

    /** 审批状态 */
    private Integer spStatus;

    /** 条款表单schema */
    private String clausesForm;

    /** 创建时间 */
    private LocalDateTime createTime;

    /** 创建人 */
    private String createBy;

    /** 修改时间 */
    private LocalDateTime updateTime;

    /** 修改人 */
    private String updateBy;

    /** 逻辑删除标志，0：正常，1：已删除 */
    private Integer delFlag;

    /** 模板ID */
    private String tplId;

    /** 合同模块：0：钢材，1：散货，3：其他 */
    private Integer contractModule;

    /** 上传文件名称 */
    private String fileName;

    /** 预览用的文件url */
    private String previewFileUrl;

    /** 签章后的文件名称 */
    private String signedFileName;

    /** 模板schema */
    private String tplSchema;

    /** 创建数据的来源 */
    private String source;

    /** 合同状态 */
    private Integer status;

    /** 我是甲方 */
    private Boolean myIsPartyA;
}