/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package com.zthzinfo.contract.service.dto;

import com.zthzinfo.contract.utils.Query;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;

/**
* @website https://el-admin.vip
* @author zhaoey
* @date 2021-12-14
**/
@Data
public class CtrtContractQueryCriteria {

    @Query
    private String contractNo;

    @Query
    private Integer spStatus;

    @Query
    private Integer status;

    @Query(type = Query.Type.INNER_LIKE)
    private String partyAName;

    @Query(type = Query.Type.INNER_LIKE)
    private String partyBName;

    @Query
    private Integer contractType;

    @Query
    private Integer contractModule;

    @Query(type = Query.Type.BETWEEN)
    private List<Timestamp> createTime;

    @Query(type = Query.Type.IN, propName = "my_is_party_a")
    private List<Integer> myIsPartyAIn;

}