/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package com.zthzinfo.contract.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author zhaoey
* @date 2021-12-14
**/
@Data
public class TplContractClausesDto implements Serializable {

    /** 模板条款ID */
    private String id;

    /** 模板ID */
    private String tplId;

    /** 条款内容 */
    private String content;

    /** 是否标准合同 */
    private Boolean standard;

    /** 是否允许修改 */
    private Boolean enableChange;

    /** 条款下需要展示的表格 */
    private String showTable;

    /** 条款类型，0：正常条款，1：顶部 */
    private Integer clausesType;

    /** 条款标题 */
    private String contentTitle;

    private Integer sort;

    /** 创建时间 */
    private Timestamp createTime;

    /** 创建人 */
    private String createBy;

    /** 修改时间 */
    private Timestamp updateTime;

    /** 修改人 */
    private String updateBy;

    /** 逻辑删除标志，0：正常，1：已删除 */
    private Integer delFlag;
}