/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package com.zthzinfo.contract.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author zhaoey
* @date 2021-12-14
**/
@Data
public class TplContractDto implements Serializable {

    /** 模板ID */
    private String id;

    /** 表单schema */
    private String formSchema;

    /** 模块：1、钢材，2、散货，3、其他 */
    private Integer module;

    /** 创建时间 */
    private Timestamp createTime;

    /** 创建人 */
    private String createBy;

    /** 修改时间 */
    private Timestamp updateTime;

    /** 修改人 */
    private String updateBy;

    /** 逻辑删除标志，0：正常，1：已删除 */
    private Integer delFlag;

    /** 合同模板名称 */
    private String name;

    /** 是否使用模板 */
    private Boolean useTpl;
}