package com.zthzinfo.contract.service.impl;

import com.github.pagehelper.PageInfo;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.base.QueryHelpPlus;
import com.zthzinfo.contract.domain.ContractChangeStatusLog;
import com.zthzinfo.contract.mapper.CtrtContractChangeStatusLogMapper;
import com.zthzinfo.contract.model.dto.ContractChangeStatusLogQueryCriteria;
import com.zthzinfo.contract.service.CtrtContractChangeStatusLogService;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 合同状态变更记录表(ContractChangeStatusLog)表服务实现类
 *
 * @author zhaoey
 * @since 2022-01-27 10:46:45
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class CtrtContractChangeStatusLogServiceImpl extends BaseServiceImpl<CtrtContractChangeStatusLogMapper, ContractChangeStatusLog> implements CtrtContractChangeStatusLogService {
    @Resource
    private CtrtContractChangeStatusLogMapper ctrtContractChangeStatusLogMapper;

    @Override
    public Map<String, Object> queryAll(ContractChangeStatusLogQueryCriteria criteria, Pageable pageable) {
        getPage(pageable);
        PageInfo<ContractChangeStatusLog> page = new PageInfo<>(this.queryAll(criteria));
        return toMap(page);
    }

    @Override
    public List<ContractChangeStatusLog> queryAll(ContractChangeStatusLogQueryCriteria criteria) {
        return list(QueryHelpPlus.getPredicate(ContractChangeStatusLog.class, criteria));
    }


}
