package com.zthzinfo.contract.service.impl;

import com.github.pagehelper.PageInfo;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.base.QueryHelpPlus;
import com.zthzinfo.contract.domain.ContractClauses;
import com.zthzinfo.contract.mapper.CtrtContractClausesMapper;
import com.zthzinfo.contract.service.CtrtContractClausesService;
import com.zthzinfo.contract.service.dto.ContractClausesDto;
import com.zthzinfo.contract.service.dto.ContractClausesQueryCriteria;
import com.zthzinfo.contract.service.mapstruct.ContractClausesSMapper;
import com.zthzinfo.contract.utils.FileUtil;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
* @description 服务实现
* @author zhaoey
* @date 2021-12-14
**/
@Service
public class CtrtContractClausesServiceImpl extends BaseServiceImpl<CtrtContractClausesMapper, ContractClauses> implements CtrtContractClausesService {

    @Resource
    private ContractClausesSMapper contractClausesSMapper;
    @Resource
    private CtrtContractClausesMapper CtrtContractClausesMapper;

    @Override
    public Map<String,Object> queryAll(ContractClausesQueryCriteria criteria, Pageable pageable){
        getPage(pageable);
        PageInfo<ContractClausesDto> page = new PageInfo<>(queryAll(criteria));
        return toMap(page);
    }

    @Override
    public List<ContractClausesDto> queryAll(ContractClausesQueryCriteria criteria){
        return listToDto(list(QueryHelpPlus.getPredicate(ContractClauses.class, criteria)),contractClausesSMapper);
    }

    @Override
    public void download(List<ContractClausesDto> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (ContractClausesDto contractClauses : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("合同ID", contractClauses.getContractId());
            map.put("合同内容", contractClauses.getContent());
            map.put("是否标准合同条款", contractClauses.getStandard());
            map.put("合同模板条款ID", contractClauses.getTplClaueseId());
            map.put("是否允许修改", contractClauses.getEnableChange());
            map.put("条款项需要添加表格", contractClauses.getShowTable());
            map.put("条款标题", contractClauses.getContentTitle());
            map.put("创建时间", contractClauses.getCreateTime());
            map.put("创建人", contractClauses.getCreateBy());
            map.put("修改时间", contractClauses.getUpdateTime());
            map.put("修改人", contractClauses.getUpdateBy());
            map.put("逻辑删除标志，0：正常，1：已删除", contractClauses.getDelFlag());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}