package com.zthzinfo.contract.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.domain.IdGen;
import com.zthzinfo.contract.mapper.CtrtIdGenMapper;
import com.zthzinfo.contract.service.CtrtIdGenService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.StringJoiner;

/**
 * id生成 ServiceImpl
 *
 * @author zhaoey
 * @since 12/20/2021
 */
@Service
public class CtrtIdGenServiceImpl extends BaseServiceImpl<CtrtIdGenMapper, IdGen> implements CtrtIdGenService {
    @Resource
    private CtrtIdGenMapper ctrtIdGenMapper;

    @Override
    public synchronized String genNumber(String companyCode,String deptCode,String typeCode) {
        IdGen idGen = getOne(new LambdaQueryWrapper<IdGen>()
                .eq(IdGen::getCompanyCode, companyCode)
                .eq(IdGen::getDeptCode, deptCode)
                .eq(IdGen::getTypeCode, typeCode)
                .last("limit 1"));
        if (idGen == null) {
            idGen = new IdGen();
            idGen.setCompanyCode(companyCode);
            idGen.setDeptCode(deptCode);
            idGen.setTypeCode(typeCode);
            idGen.setBusinessCount(0);
            save(idGen);
        }

        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));

        String businessCount = businessCount(idGen.getBusinessCount());

        // 最终格式：20220210-HNCGWL-ZC-Z-1
        return new StringJoiner("-")
                .add(date)
                .add(companyCode)
                .add(deptCode)
                .add(typeCode)
                .add(businessCount)
                .toString();
    }

    @Override
    public synchronized void incrNumber(String companyCode,String deptCode,String typeCode) {
        IdGen idGen = getOne(new LambdaQueryWrapper<IdGen>()
                .eq(IdGen::getCompanyCode, companyCode)
                .eq(IdGen::getDeptCode, deptCode)
                .eq(IdGen::getTypeCode, typeCode)
                .last("limit 1"));
        if (idGen == null) {
            return;
        }
        Integer curMonthCount = idGen.getBusinessCount();
        curMonthCount += 1;
        idGen.setBusinessCount(curMonthCount);
        updateById(idGen);
    }

    @Override
    public synchronized String incrementAndGet(String companyCode,String deptCode,String typeCode) {
        String num = genNumber(companyCode,deptCode,typeCode);
        incrNumber(companyCode,deptCode,typeCode);
        return num;
    }

    private String businessCount(Integer count) {
        if (count == null) {
            count = 0;
        }
        count += 1;
        String countStr = String.valueOf(count);
        int len = 3; // 总长度
        int mLen = countStr.length();
        for (int i = 0; i < len - mLen; i++) {
            countStr = 0 + countStr;
        }
        return countStr;
    }
}
