package com.zthzinfo.contract.service.impl;

import com.github.pagehelper.PageInfo;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.base.QueryHelpPlus;
import com.zthzinfo.contract.domain.TplContractClauses;
import com.zthzinfo.contract.mapper.CtrtTplContractClausesMapper;
import com.zthzinfo.contract.service.CtrtTplContractClausesService;
import com.zthzinfo.contract.service.dto.TplContractClausesDto;
import com.zthzinfo.contract.service.dto.TplContractClausesQueryCriteria;
import com.zthzinfo.contract.service.mapstruct.TplContractClausesSMapper;
import com.zthzinfo.contract.utils.FileUtil;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
* @description 服务实现
* @author zhaoey
* @date 2021-12-14
**/
@Service
public class CtrtTplContractClausesServiceImpl extends BaseServiceImpl<CtrtTplContractClausesMapper, TplContractClauses> implements CtrtTplContractClausesService {

    @Resource
    private TplContractClausesSMapper tplContractClausesSMapper;
    @Resource
    private CtrtTplContractClausesMapper ctrtTplContractClausesMapper;

    @Override
    public Map<String,Object> queryAll(TplContractClausesQueryCriteria criteria, Pageable pageable){
        getPage(pageable);
        PageInfo<TplContractClausesDto> page = new PageInfo<>(queryAll(criteria));
        return toMap(page);
    }

    @Override
    public List<TplContractClausesDto> queryAll(TplContractClausesQueryCriteria criteria){
        return listToDto(list(QueryHelpPlus.getPredicate(TplContractClauses.class, criteria)),tplContractClausesSMapper);
    }

    @Override
    public void download(List<TplContractClausesDto> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TplContractClausesDto tplContractClauses : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("模板ID", tplContractClauses.getTplId());
            map.put("条款内容", tplContractClauses.getContent());
            map.put("是否标准合同", tplContractClauses.getStandard());
            map.put("是否允许修改", tplContractClauses.getEnableChange());
            map.put("条款下需要展示的表格", tplContractClauses.getShowTable());
            map.put("条款类型，0：正常条款，1：顶部", tplContractClauses.getClausesType());
            map.put("条款标题", tplContractClauses.getContentTitle());
            map.put("创建时间", tplContractClauses.getCreateTime());
            map.put("创建人", tplContractClauses.getCreateBy());
            map.put("修改时间", tplContractClauses.getUpdateTime());
            map.put("修改人", tplContractClauses.getUpdateBy());
            map.put("逻辑删除标志，0：正常，1：已删除", tplContractClauses.getDelFlag());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}