package com.zthzinfo.contract.service.impl;

import com.github.pagehelper.PageInfo;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.base.QueryHelpPlus;
import com.zthzinfo.contract.domain.TplContract;
import com.zthzinfo.contract.mapper.CtrtTplContractMapper;
import com.zthzinfo.contract.service.CtrtTplContractService;
import com.zthzinfo.contract.service.dto.TplContractDto;
import com.zthzinfo.contract.service.dto.TplContractQueryCriteria;
import com.zthzinfo.contract.service.mapstruct.TplContractSMapper;
import com.zthzinfo.contract.utils.FileUtil;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
* @description 服务实现
* @author zhaoey
* @date 2021-12-14
**/
@Service
public class CtrtTplContractServiceImpl extends BaseServiceImpl<CtrtTplContractMapper, TplContract> implements CtrtTplContractService {

    @Resource
    private TplContractSMapper tplContractSMapper;
    @Resource
    private CtrtTplContractMapper ctrtTplContractMapper;

    @Override
    public Map<String,Object> queryAll(TplContractQueryCriteria criteria, Pageable pageable){
        getPage(pageable);
        PageInfo<TplContractDto> page = new PageInfo<>(queryAll(criteria));
        return toMap(page);
    }

    @Override
    public List<TplContractDto> queryAll(TplContractQueryCriteria criteria){
        return listToDto(list(QueryHelpPlus.getPredicate(TplContract.class, criteria)),tplContractSMapper);
    }

    @Override
    public void download(List<TplContractDto> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TplContractDto tplContract : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("表单schema", tplContract.getFormSchema());
            map.put("模块：1、钢材，2、散货，3、其他", tplContract.getModule());
            map.put("创建时间", tplContract.getCreateTime());
            map.put("创建人", tplContract.getCreateBy());
            map.put("修改时间", tplContract.getUpdateTime());
            map.put("修改人", tplContract.getUpdateBy());
            map.put("逻辑删除标志，0：正常，1：已删除", tplContract.getDelFlag());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}