/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.zthzinfo.contract.base.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelpPlus {
    private static final Logger log = LoggerFactory.getLogger(QueryHelpPlus.class);

    public static <R, Q> QueryWrapper getPredicate(R obj, Q query) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (query == null) {
            return queryWrapper;
        }
        try {
            List<Field> fields = QueryHelpPlus.getAllFields(query.getClass(), new ArrayList<Field>());
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Query q = field.getAnnotation(Query.class);
                if (q != null) {
                    String propName = q.propName();
                    String blurry = q.blurry();
                    String attributeName = QueryHelpPlus.isBlank(propName) ? field.getName() : propName;
                    attributeName = QueryHelpPlus.humpToUnderline(attributeName);
                    Class<?> fieldType = field.getType();
                    Object val = field.get(query);
                    if (ObjectUtil.isNull((Object)val) || "".equals(val)) continue;
                    if (ObjectUtil.isNotEmpty((Object)blurry)) {
                        String[] blurrys = blurry.split(",");
                        queryWrapper.and(wrapper -> {
                            for (int i = 0; i < blurrys.length; ++i) {
                                String column = QueryHelpPlus.humpToUnderline(blurrys[i]);
                                wrapper.or();
                                wrapper.like((Object)column, (Object)val.toString());
                            }
                        });
                        continue;
                    }
                    String finalAttributeName = attributeName;
                    switch (q.type()) {
                        case EQUAL: {
                            queryWrapper.eq((Object)attributeName, val);
                            break;
                        }
                        case GREATER_THAN: {
                            queryWrapper.ge((Object)finalAttributeName, val);
                            break;
                        }
                        case LESS_THAN: {
                            queryWrapper.le((Object)finalAttributeName, val);
                            break;
                        }
                        case LESS_THAN_NQ: {
                            queryWrapper.lt((Object)finalAttributeName, val);
                            break;
                        }
                        case INNER_LIKE: {
                            queryWrapper.like((Object)finalAttributeName, val);
                            break;
                        }
                        case LEFT_LIKE: {
                            queryWrapper.likeLeft((Object)finalAttributeName, val);
                            break;
                        }
                        case RIGHT_LIKE: {
                            queryWrapper.likeRight((Object)finalAttributeName, val);
                            break;
                        }
                        case IN: {
                            if (!CollUtil.isNotEmpty((Collection)((Collection)val))) break;
                            queryWrapper.in((Object)finalAttributeName, (Collection)val);
                            break;
                        }
                        case NOT_EQUAL: {
                            queryWrapper.ne((Object)finalAttributeName, val);
                            break;
                        }
                        case NOT_NULL: {
                            queryWrapper.isNotNull((Object)finalAttributeName);
                            break;
                        }
                        case BETWEEN: {
                            ArrayList between = new ArrayList((List)val);
                            queryWrapper.between((Object)finalAttributeName, between.get(0), between.get(1));
                            break;
                        }
                    }
                }
                field.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return queryWrapper;
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static List<Field> getAllFields(Class clazz, List<Field> fields) {
        if (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            QueryHelpPlus.getAllFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }

    public static String humpToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        if (!para.contains("_")) {
            for (int i = 0; i < para.length(); ++i) {
                if (!Character.isUpperCase(para.charAt(i))) continue;
                sb.insert(i + temp, "_");
                ++temp;
            }
        }
        return sb.toString();
    }
}

