/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.handler.dispatcher;

import com.zthzinfo.contract.handler.IContractFileExchange;
import com.zthzinfo.contract.model.dto.FileParams;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ContractFileDispatcher
implements ApplicationContextAware {
    private Collection<IContractFileExchange> exchanges;

    public String dispatch(FileParams params) {
        for (IContractFileExchange exchange : this.exchanges) {
            if (!exchange.support(params.getContractType())) continue;
            return exchange.exchange(params);
        }
        throw new IllegalArgumentException(String.format("[%s]\u6ca1\u6709\u5339\u914d\u7684\u5904\u7406\u5668", params.getModule()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.exchanges = applicationContext.getBeansOfType(IContractFileExchange.class).values();
    }
}

