/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.common;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisLock {
    private static Logger logger = LoggerFactory.getLogger(RedisLock.class);
    private static final String LOCKED = "LOCKED";
    private static final long TIME_OUT = 100L;
    public static final int EXPIRE = 60;
    private String key;
    private int expireTime = 60;
    private long timeOut = 100L;
    private volatile boolean isLocked = false;
    private StringRedisTemplate redisTemplate;

    public RedisLock(StringRedisTemplate redisTemplate, String key, int expireTime, long timeOut) {
        this.key = key;
        this.expireTime = expireTime;
        this.timeOut = timeOut;
        this.redisTemplate = redisTemplate;
    }

    public RedisLock(StringRedisTemplate redisTemplate, String key, int expireTime) {
        this.key = key;
        this.expireTime = expireTime;
        this.redisTemplate = redisTemplate;
    }

    public RedisLock(StringRedisTemplate redisTemplate, String key) {
        this.key = key;
        this.redisTemplate = redisTemplate;
    }

    public boolean lock() {
        long nowTime = System.nanoTime();
        long timeout = this.timeOut * 1000000L;
        Random random = new Random();
        while (System.nanoTime() - nowTime < timeout) {
            if (this.redisTemplate.opsForValue().setIfAbsent((Object)this.key, (Object)LOCKED).booleanValue()) {
                this.isLocked = true;
                this.redisTemplate.expire((Object)this.key, (long)this.expireTime, TimeUnit.SECONDS);
                break;
            }
            try {
                Thread.sleep(10L, random.nextInt(50000));
            }
            catch (InterruptedException e) {
                logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u4f11\u7720\u88ab\u4e2d\u65ad\uff1a", (Throwable)e);
            }
        }
        return this.isLocked;
    }

    public boolean isLock() {
        this.redisTemplate.getConnectionFactory().getConnection().time();
        return this.redisTemplate.hasKey((Object)this.key);
    }

    public void unlock() {
        if (this.isLocked) {
            this.redisTemplate.delete((Object)this.key);
        }
    }
}

