/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.libs.dictionary.mongo;

import com.mongodb.client.result.UpdateResult;
import com.zthzinfo.libs.dictionary.mongo.IDynamicMongoTable;
import com.zthzinfo.libs.dictionary.mongo.entity.MongoDictionary;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MongoDictionaryService {
    @Autowired(required=false)
    protected MongoTemplate mongoTemplate;
    protected String tableName;
    protected IDynamicMongoTable dynamicMongoTable;

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public IDynamicMongoTable getDynamicMongoTable() {
        return this.dynamicMongoTable;
    }

    public void setDynamicMongoTable(IDynamicMongoTable dynamicMongoTable) {
        this.dynamicMongoTable = dynamicMongoTable;
    }

    public List<MongoDictionary> queryList(String key) {
        return this.queryListByTableName(key, null, this.calcTableName());
    }

    private List<MongoDictionary> queryList(String key, String subKey) {
        return this.queryListByTableName(key, subKey, this.calcTableName());
    }

    public MongoDictionary queryDictionary(String key, String subKey) {
        return this.queryDictonaryByTableName(key, subKey, this.calcTableName());
    }

    public MongoDictionary queryDictionary(String key) {
        return this.queryDictonaryByTableName(key, this.calcTableName());
    }

    public List<MongoDictionary> dynamicQueryList(String key) {
        return this.queryListByTableName(key, null, this.calcDynamicTableName());
    }

    public List<MongoDictionary> dynamicQueryList(String key, String subKey) {
        return this.queryListByTableName(key, subKey, this.calcDynamicTableName());
    }

    public MongoDictionary dynamicQueryDictionary(String key, String subKey) {
        return this.queryDictonaryByTableName(key, subKey, this.calcDynamicTableName());
    }

    public MongoDictionary dynamicQueryDictionary(String key) {
        return this.queryDictonaryByTableName(key, this.calcDynamicTableName());
    }

    public UpdateResult update(String key, String subKey, String prop, Object obj) {
        Query query = this.getQuery(key, subKey);
        return this.mongoTemplate.updateMulti(query, new Update().set(prop, obj), this.calcTableName());
    }

    private Query getQuery(String key, String subKey) {
        Criteria criteria = Criteria.where((String)"key").is((Object)key);
        if (subKey != null && subKey.trim().length() != 0) {
            criteria.and("subKey").is((Object)subKey);
        }
        return new Query((CriteriaDefinition)criteria);
    }

    private List<MongoDictionary> queryListByTableName(String key, String subKey, String tableName) {
        if (this.mongoTemplate == null) {
            return null;
        }
        if (tableName == null || tableName.trim().length() == 0) {
            return null;
        }
        Query query = this.getQuery(key, subKey);
        List mongoDictionaries = this.mongoTemplate.find(query, MongoDictionary.class, tableName);
        return mongoDictionaries;
    }

    private List<MongoDictionary> queryListByTableName(String key, String tableName) {
        return this.queryListByTableName(key, null, tableName);
    }

    private MongoDictionary queryDictonaryByTableName(String key, String subKey, String tableName) {
        List<MongoDictionary> mongoDictionaries = this.queryListByTableName(key, subKey, tableName);
        if (mongoDictionaries == null || mongoDictionaries.size() == 0) {
            return null;
        }
        return mongoDictionaries.get(0);
    }

    private MongoDictionary queryDictonaryByTableName(String key, String tableName) {
        return this.queryDictonaryByTableName(key, null, tableName);
    }

    private String calcTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.dynamicMongoTable != null) {
            return this.calcDynamicTableName();
        }
        return null;
    }

    private String calcDynamicTableName() {
        if (this.dynamicMongoTable == null) {
            throw new IllegalArgumentException("\u672a\u914d\u7f6e\u591a\u8868\u8def\u7531\u5668\uff08dynamicMongoTable\u5c5e\u6027\uff09");
        }
        String dynamicName = this.dynamicMongoTable.getTableName();
        if (dynamicName == null || dynamicName.trim().length() == 0) {
            return null;
        }
        return dynamicName;
    }
}

