/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.libs.dynamicds;

import com.zthzinfo.libs.dynamicds.DynamicDataSource;
import com.zthzinfo.libs.dynamicds.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DynamicDataSourceRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    protected Binder binder;
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourceRegister.class);
    private static final Object DATASOURCE_TYPE_DEFAULT = "com.alibaba.druid.pool.DruidDataSource";
    private DataSource defaultDataSource;
    private Map<String, DataSource> customDataSources = new HashMap<String, DataSource>();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        if (this.defaultDataSource != null) {
            targetDataSources.put("dataSource", this.defaultDataSource);
            DynamicDataSourceContextHolder.dataSourceIds.add("dataSource");
        }
        targetDataSources.putAll(this.customDataSources);
        for (String key : this.customDataSources.keySet()) {
            DynamicDataSourceContextHolder.dataSourceIds.add(key);
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DynamicDataSource.class);
        beanDefinition.setSynthetic(true);
        MutablePropertyValues mpv = beanDefinition.getPropertyValues();
        if (this.defaultDataSource != null) {
            mpv.addPropertyValue("defaultTargetDataSource", (Object)this.defaultDataSource);
        }
        mpv.addPropertyValue("targetDataSources", targetDataSources);
        registry.registerBeanDefinition("dataSource", (BeanDefinition)beanDefinition);
        logger.info("Dynamic DataSource Registry");
    }

    public DataSource buildDataSource(Map<String, Object> dsMap) {
        try {
            Object type = dsMap.get("type");
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> dataSourceType = Class.forName((String)type);
            String driverClassName = dsMap.get("driver-class-name").toString();
            String url = dsMap.get("url").toString();
            String username = dsMap.get("username").toString();
            String password = dsMap.get("password").toString();
            DataSourceBuilder factory = DataSourceBuilder.create().driverClassName(driverClassName).url(url).username(username).password(password).type(dataSourceType);
            return factory.build();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setEnvironment(Environment env) {
        this.binder = Binder.get((Environment)env);
        this.initDefaultDataSource(env);
        this.initCustomDataSources(env);
    }

    private void initDefaultDataSource(Environment env) {
        String defaultDsUrl = env.getProperty("spring.datasource.url");
        if (defaultDsUrl == null || defaultDsUrl.trim().length() == 0) {
            return;
        }
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("type", env.getProperty("spring.datasource.type"));
        dsMap.put("driver-class-name", env.getProperty("spring.datasource.driver-class-name"));
        dsMap.put("url", defaultDsUrl);
        dsMap.put("username", env.getProperty("spring.datasource.username"));
        dsMap.put("password", env.getProperty("spring.datasource.password"));
        this.defaultDataSource = this.buildDataSource(dsMap);
        this.dataBinder(this.defaultDataSource, env);
    }

    private void dataBinder(DataSource dataSource, Environment env) {
        Binder binder = new Binder(ConfigurationPropertySources.get((Environment)env));
        binder.bind("spring.datasource.default", Bindable.ofInstance((Object)dataSource));
    }

    private void initCustomDataSources(Environment env) {
        String dsPrefixs = env.getProperty("custom.datasource.names");
        if (dsPrefixs == null) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split("\\s*,\\s*")) {
            Map dsMap = (Map)this.binder.bind("custom.datasource." + dsPrefix.trim(), Bindable.mapOf(String.class, Object.class)).get();
            DataSource ds = this.buildDataSource(dsMap);
            this.customDataSources.put(dsPrefix, ds);
            this.dataBinder(ds, env);
        }
    }
}

