package com.zthzinfo.microservice.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class MSSecurityInterceptor implements HandlerInterceptor {

	private String pk;

	private Function<HttpServletRequest, String> pkGetter;


	public String getPk(HttpServletRequest request) {
		if (pk != null) {
			return pk;
		} else if (pkGetter != null){
			return pkGetter.apply(request);
		}
		return "";
	}

	public MSSecurityInterceptor(String pk) {
		this.pk	 = pk;
	}
	public MSSecurityInterceptor(Function<HttpServletRequest, String> pkGetter) {
		this.pkGetter	 = pkGetter;
	}

	Logger logger = LoggerFactory.getLogger(MSSecurityInterceptor.class);

	@Override
	public boolean preHandle(final HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

		String headerTime = request.getHeader(MSConstants.HEAD_KEY_TIME);
		String headerToken = request.getHeader(MSConstants.HEAD_KEY_TOKEN);
		if (headerTime == null) {
			return false;
		}
		if (headerToken == null) {
			return false;
		}

		Enumeration<String> parameterNames = request.getParameterNames();
		final  Map<String, String> params = new HashMap<>();

		while (parameterNames.hasMoreElements()) {
			String key = parameterNames.nextElement();
			String value = request.getParameter(key);
			params.put(key, value);
			logger.debug(key);
		}

		params.put(MSConstants.HEAD_KEY_TIME, headerTime);

		String token = TokenUtil.generateToken(this.getPk(request), params.keySet(), new TokenUtil.ParamMap() {
			@Override
			public String getValue(String var1) {
				return params.get(var1);
			}
		});

		if (!token.equalsIgnoreCase(headerToken)) {
			return false;
		}


		return true;

	}


	public String getPk() {
		return pk;
	}

	public void setPk(String pk) {
		this.pk = pk;
	}

	public Function<HttpServletRequest, String> getPkGetter() {
		return pkGetter;
	}

	public void setPkGetter(Function<HttpServletRequest, String> pkGetter) {
		this.pkGetter = pkGetter;
	}
}
