package com.zthzinfo.microservice.security;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class MSOKHttp3InterceptorClient implements Interceptor {

	private String pk;
	public MSOKHttp3InterceptorClient(String pk) {
		this.pk	 = pk;
	}

	@Override
	public Response intercept(Chain chain) throws IOException {
		Request request = chain.request();
		final Map<String, String> params = OKHttp3Util.getParams(request);
		String msec_time = (new Date().getTime() / 1000l) + "";
		params.put(MSConstants.HEAD_KEY_TIME, msec_time);

		String token = TokenUtil.generateToken(this.pk, params.keySet(), new TokenUtil.ParamMap() {
			@Override
			public String getValue(String var1) {
				return params.get(var1);
			}
		});
		Request.Builder method = request.newBuilder()
				.headers(request.headers())
				.url(request.url())
				.method(request.method(), request.body())
				.addHeader(MSConstants.HEAD_KEY_TOKEN, token)
				.addHeader(MSConstants.HEAD_KEY_TIME, msec_time);

		Response response = chain.proceed(method.build());

		return response;
	}

}
