package com.zthzinfo.microservice.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class MSSecurityInterceptor implements HandlerInterceptor {

	private String pk;

	private String key_time;
	private String key_token;

	private String enableDebug = null;

	private Function<HttpServletRequest, String> pkGetter;


	public String getPk(HttpServletRequest request) {
		if (pk != null) {
			return pk;
		} else if (pkGetter != null){
			return pkGetter.apply(request);
		}
		return null;
	}

	public MSSecurityInterceptor(String pk) {
		this.pk	 = pk;
	}
	public MSSecurityInterceptor(Function<HttpServletRequest, String> pkGetter) {
		this.pkGetter	 = pkGetter;
	}

	Logger logger = LoggerFactory.getLogger(MSSecurityInterceptor.class);

	@Override
	public boolean preHandle(final HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		if (this.getEnableDebug() != null || this.getEnableDebug().trim().length() > 0) {
			String parameter = request.getParameter(this.getEnableDebug());
			if (parameter != null && !parameter.equals("0")) {
				return true;
			}
		}
		String k_time = key_time != null ? key_time : MSConstants.HEAD_KEY_TIME;
		String k_token = key_token != null ? key_token : MSConstants.HEAD_KEY_TOKEN;

		String headerTime = request.getHeader(k_time);
		String headerToken = request.getHeader(k_token);
		if (headerTime == null) {
			return false;
		}
		if (headerToken == null) {
			return false;
		}
		String pk = this.getPk(request);
		if (pk == null) {
			return false;
		}

		Enumeration<String> parameterNames = request.getParameterNames();
		final  Map<String, String> params = new HashMap<>();

		while (parameterNames.hasMoreElements()) {
			String key = parameterNames.nextElement();
			String value = request.getParameter(key);
			params.put(key, value);
			logger.debug(key);
		}

		params.put(key_time, headerTime);

		String token = TokenUtil.generateToken(pk, params.keySet(), new TokenUtil.ParamMap() {
			@Override
			public String getValue(String var1) {
				return params.get(var1);
			}
		});

		if (!token.equalsIgnoreCase(headerToken)) {
			return false;
		}


		return true;

	}


	public String getPk() {
		return pk;
	}

	public void setPk(String pk) {
		this.pk = pk;
	}

	public Function<HttpServletRequest, String> getPkGetter() {
		return pkGetter;
	}

	public void setPkGetter(Function<HttpServletRequest, String> pkGetter) {
		this.pkGetter = pkGetter;
	}

	public String getKey_time() {
		return key_time;
	}

	public void setKey_time(String key_time) {
		this.key_time = key_time;
	}

	public String getKey_token() {
		return key_token;
	}

	public void setKey_token(String key_token) {
		this.key_token = key_token;
	}

	public String getEnableDebug() {
		return enableDebug;
	}

	public void setEnableDebug(String enableDebug) {
		this.enableDebug = enableDebug;
	}
}
