package com.zthzinfo.microservice.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class TokenUtil {
	static Logger logger = LoggerFactory.getLogger(TokenUtil.class);

	public static String generateToken(String PK, Collection<String> keys, TokenUtil.ParamMap paramMap) {
		if (PK == null) {
			return null;
		} else {
			String strOri = generateSource(PK, keys, paramMap);
			logger.debug(strOri);
			String token = Encryp.getInstance().md5(strOri);
			return token;
		}
	}

	public static String generateSource(String PK, Collection<String> keys, TokenUtil.ParamMap paramMap) {
		StringBuffer strOri = new StringBuffer();
		List<String> keysBySort = new ArrayList(keys);
		Collections.sort(keysBySort);
		Iterator i$ = keysBySort.iterator();

		while(i$.hasNext()) {
			String key = (String)i$.next();
			String value = paramMap.getValue(key);
			strOri.append((value == null ? "" : value) + "|");
		}

		strOri.append(PK);
		return strOri.toString();
	}


	public interface ParamMap {
		String getValue(String var1);
	}
}
