/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.sdks.netease.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NECheckSumBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class NEResquester {
    public static final String BASE_URL = "https://api.netease.im";
    private String appKey;
    private String appSecret;
    private String nonce;

    public JSONObject getJSONObjectOnly200(String url, List<NameValuePair> nvps) {
        JSONObject jsonObject = this.getJSONObject(url, nvps);
        if (jsonObject.getInteger("code") != 200) {
            new RuntimeException("\u7f51\u6613\u8fd4\u56de\u5f02\u5e38\uff1a" + jsonObject.toJSONString()).printStackTrace();
            return null;
        }
        return jsonObject;
    }

    public JSONObject getJSONObject(String url, List<NameValuePair> nvps) {
        String jsonStr = this.request(url, nvps);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)jsonStr);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fd4\u56de\u683c\u5f0f\u5e76\u975eJsonObject", e);
        }
        if (jsonObject.getInteger("code") != 200) {
            new RuntimeException("\u7f51\u6613\u8fd4\u56de\u5f02\u5e38\uff1a" + jsonStr).printStackTrace();
            return null;
        }
        return jsonObject;
    }

    public String request(String url, List<NameValuePair> nvps) {
        if (this.appKey == null || this.appKey.trim().length() == 0) {
            throw new IllegalArgumentException("\u7f3a\u5c11appKey\u914d\u7f6e");
        }
        if (this.appSecret == null || this.appSecret.trim().length() == 0) {
            throw new IllegalArgumentException("\u7f3a\u5c11appSecret\u914d\u7f6e");
        }
        if (this.nonce == null || this.nonce.trim().length() == 0) {
            throw new IllegalArgumentException("\u7f3a\u5c11nonce\u914d\u7f6e");
        }
        HttpClientBuilder httpClient = HttpClientBuilder.create();
        HttpPost httpPost = new HttpPost(url);
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        String checkSum = NECheckSumBuilder.getCheckSum(this.appSecret, this.nonce, curTime);
        httpPost.addHeader("AppKey", this.appKey);
        httpPost.addHeader("Nonce", this.nonce);
        httpPost.addHeader("CurTime", curTime);
        httpPost.addHeader("CheckSum", checkSum);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            response = httpClient.build().execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException("\u7f51\u6613\u63a5\u53e3\u5f02\u5e38", e);
        }
    }
}

