package com.zthzinfo.sdks.netease.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

/**
 * Created by sunzsh on 2016/12/15.
 */
public class NEResquester {
	public static final String BASE_URL = "https://api.netease.im";

	private String appKey;
	private String appSecret;
	private String nonce;

	/**
	 * 请求一个返回码为200时的JsonObject数据，否则返回空
	 *
	 * @param url  完整接口地址，根路径可参考变量：NEResquester.BASE_URL
	 * @param nvps 请求参数
	 * @return 响应内容
	 */
	public JSONObject getJSONObjectOnly200(String url, List<NameValuePair> nvps) {
		JSONObject jsonObject = getJSONObject(url, nvps);
		if (jsonObject.getInteger("code") != 200) {
			new RuntimeException("网易返回异常：" + jsonObject.toJSONString()).printStackTrace();
			return null;
		}
		return jsonObject;
	}

	/**
	 * 请求一个JsonObject数据
	 *
	 * @param url  完整接口地址，根路径可参考变量：NEResquester.BASE_URL
	 * @param nvps 请求参数
	 * @return 响应内容
	 */
	public JSONObject getJSONObject(String url, List<NameValuePair> nvps) {
		String jsonStr = request(url, nvps);
		JSONObject jsonObject = null;
		try {
			jsonObject = JSON.parseObject(jsonStr);
		} catch (Exception e) {
			throw new RuntimeException("返回格式并非JsonObject", e);
		}
		return jsonObject;
	}

	/**
	 * 请求网易接口
	 *
	 * @param url  完整接口地址，根路径可参考变量：NEResquester.BASE_URL
	 * @param nvps 请求参数
	 * @return 响应内容
	 */
	public String request(String url, List<NameValuePair> nvps) {
		if (appKey == null || appKey.trim().length() == 0) {
			throw new IllegalArgumentException("缺少appKey配置");
		}
		if (appSecret == null || appSecret.trim().length() == 0) {
			throw new IllegalArgumentException("缺少appSecret配置");
		}
		if (nonce == null || nonce.trim().length() == 0) {
			throw new IllegalArgumentException("缺少nonce配置");
		}
		HttpClientBuilder httpClient = HttpClientBuilder.create();
		HttpPost httpPost = new HttpPost(url);

		String curTime = String.valueOf((new Date()).getTime() / 1000L);
		String checkSum = NECheckSumBuilder.getCheckSum(appSecret, nonce, curTime);// 计算CheckSum的java代码

		// 设置请求的header
		httpPost.addHeader("AppKey", appKey);
		httpPost.addHeader("Nonce", nonce);
		httpPost.addHeader("CurTime", curTime);
		httpPost.addHeader("CheckSum", checkSum);
		httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");

		try {
			httpPost.setEntity(new UrlEncodedFormEntity(nvps, "utf-8"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		// 执行请求
		HttpResponse response = null;
		try {
			response = httpClient.build().execute(httpPost);
			return EntityUtils.toString(response.getEntity(), "utf-8");
		} catch (IOException e) {
			throw new RuntimeException("网易接口异常", e);
		}

	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	public String getNonce() {
		return nonce;
	}

	public void setNonce(String nonce) {
		this.nonce = nonce;
	}
}
