package com.zthzinfo.sdks.netease.sms.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NEResquester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.im.vo.NEIMUser;
import com.zthzinfo.sdks.netease.sms.bean.TemplateMsgParams;
import com.zthzinfo.sdks.netease.sms.vo.NESMSResult;
import com.zthzinfo.sdks.netease.sms.vo.NESMSStatus;
import org.apache.http.NameValuePair;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 发送模板短信相关
 * Created by yanghb on 16/12/16.
 */
public class NESMSService {

	private static final String SMS_BASE_URL = NEResquester.BASE_URL + "/sms";
	private NEResquester requester;


	/**
	 * 发送模板短信
	 *
	 * @param templateId    模板编号(由客户顾问配置之后告知开发者)
	 * @param mobiles      	接收者号码列表，JSONArray格式,如["186xxxxxxxx","186xxxxxxxx"]，限制接收者号码个数最多为100个
	 * @param params        短信参数列表，用于依次填充模板，JSONArray格式，如["xxx","yyy"];对于不包含变量的模板，不填此参数表示模板即短信全文内容
	 * @return NESMSResult
	 */
	private NESMSResult sendTemplateMsg(Integer templateId, String[] mobiles, String[] params) {
		if (templateId == null) {
			throw new IllegalArgumentException("templateId不能为空");
		}
		if (mobiles == null) {
			throw new IllegalArgumentException("mobiles不能为空");
		}
		String mobilesString = null;
		String paramsString = null;
		try {
			List<String> mobileList =  Arrays.asList(mobiles);
			JSONArray mobileArray = JSONArray.parseArray(mobileList.toString());
			if(mobileArray==null||mobileArray.size()==0||mobileArray.size()>100){
				throw new IllegalArgumentException("mobiles 至少填写1到100个接收者号码");
			}
			mobilesString = mobileArray.toString();
		} catch (Exception e) {
			throw new IllegalArgumentException("mobiles不是有效的JSONArray格式");
		}
		if (params != null) {
			try {
				List<String> paramsList =  Arrays.asList(mobiles);
				JSONArray.parseArray(paramsList.toString());
				paramsString = JSONArray.parseArray(paramsList.toString()).toString();
			} catch (Exception e) {
				throw new IllegalArgumentException("params不是有效的JSONArray格式");
			}

		}

		// build参数集合
		List<NameValuePair> nvps1 = NameValuePairBuilder.newBuilder()
				.addParam("templateid", templateId.toString())
				.addParam("mobiles", mobilesString)
				.addParam("params", paramsString).getParams();
		/** 发送模板短信 **/
		JSONObject sendObject = requester.getJSONObjectOnly200(SMS_BASE_URL + "/sendtemplate.action", nvps1);
		if (sendObject == null) {
			return null;
		}

		Long sendId = sendObject.getLong("obj");
		if (sendId == null){
			return null;
		}

		List<NameValuePair> nvps2 = NameValuePairBuilder.newBuilder().addParam("sendid", sendId.toString()).getParams();
		/** 发送模板短信 **/
		JSONObject queryObject = requester.getJSONObjectOnly200(SMS_BASE_URL + "/querystatus.action", nvps2);
		if (queryObject == null) {
			return null;
		}
		JSONArray statusJSONArray = queryObject.getJSONArray("obj");
		if (statusJSONArray  == null || statusJSONArray.size() == 0 ){
			return null;
		}
		List<NESMSStatus>  statusList = new ArrayList<NESMSStatus>();
		for (Object statusObject:statusJSONArray){
			JSONObject statusJson = (JSONObject)statusObject;
			NESMSStatus status  = new NESMSStatus(statusJson);
			statusList.add(status);
		}
		return new NESMSResult(sendId,statusList);
	}
	/**
	 * 发送模板短信
	 *
	 * @param templateMsgParams   模板短信参数接口  模板编号(由客户顾问配置之后告知开发者)
	 * @param mobiles      	接收者号码列表，字符串数组格式,如{“186XXXXXXXX”，“177XXXXXXX”}，限制接收者号码个数最多为100个
	 * @return NESMSResult
	 */
	public  NESMSResult sendTemplateMsg(String[] mobiles,TemplateMsgParams templateMsgParams){
		return  sendTemplateMsg(templateMsgParams.getTemplateId(),mobiles,templateMsgParams.getTemplateParams());
	}
	public NEResquester getRequester() {
		return requester;
	}
	public void setRequester(NEResquester requester) {
		this.requester = requester;
	}
}
