package com.zthzinfo.sdks.netease.common.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunzsh on 2016/12/28.
 */
public class NEBackCode {
	public static Map<Integer, String> codes;
	static {
		codes = new HashMap<>();
		codes.put(200,"操作成功");
		codes.put(201,"客户端版本不对，需升级sdk");
		codes.put(301,"被封禁");
		codes.put(302,"用户名或密码错误");
		codes.put(315,"IP限制");
		codes.put(403,"非法操作或没有权限");
		codes.put(404,"对象不存在");
		codes.put(405,"参数长度过长");
		codes.put(406,"对象只读");
		codes.put(408,"客户端请求超时");
		codes.put(413,"验证失败(短信服务)");
		codes.put(414,"参数错误");
		codes.put(415,"客户端网络问题");
		codes.put(416,"频率控制");
		codes.put(417,"重复操作");
		codes.put(418,"通道不可用(短信服务)");
		codes.put(419,"数量超过上限");
		codes.put(422,"账号被禁用");
		codes.put(431,"HTTP重复请求");
		codes.put(500,"服务器内部错误");
		codes.put(503,"服务器繁忙");
		codes.put(514,"服务不可用");
		codes.put(509,"无效协议");
		codes.put(998,"解包错误");
		codes.put(999,"打包错误");

		// 群相关错误码
		codes.put(801,"群人数达到上限");
		codes.put(802,"没有权限");
		codes.put(803,"群不存在");
		codes.put(804,"用户不在群");
		codes.put(805,"群类型不匹配");
		codes.put(806,"创建群数量达到限制");
		codes.put(807,"群成员状态错误");
		codes.put(808,"申请成功");
		codes.put(809,"已经在群内");
		codes.put(810,"邀请成功");

		// 音视频、白板通话相关错误码
		codes.put(9102,"通道失效");
		codes.put(9103,"已经在他端对这个呼叫响应过了");
		codes.put(11001,"通话不可达，对方离线状态");

		// 聊天室相关错误码
		codes.put(13001,"IM主连接状态异常");
		codes.put(13002,"聊天室状态异常");
		codes.put(13003,"账号在黑名单中,不允许进入聊天室");
		codes.put(13004,"在禁言列表中,不允许发言");

		// 特定业务相关错误码
		codes.put(431,"输入email不是邮箱");
		codes.put(432,"输入mobile不是手机号码");
		codes.put(433,"注册输入的两次密码不相同");
		codes.put(434,"企业不存在");
		codes.put(435,"登陆密码或帐号不对");
		codes.put(436,"app不存在");
		codes.put(437,"email已注册");
		codes.put(438,"手机号已注册");
		codes.put(441,"app名字已经存在");
	}

	public static String getErrorMessage(Integer code) {
		if (code == null) {
			return null;
		}
		return codes.get(code);
	}
}
