package com.zthzinfo.sdks.netease.im.service;

import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NEResquester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.im.vo.NEIMChatroom;
import org.apache.http.NameValuePair;

import java.util.List;

/**
 * IM聊天室相关
 * Created by sunzsh on 2016/12/28.
 */
public class NEIMChatroomService {

	private static final String USER_BASE_URL = NEResquester.BASE_URL + "/nimserver/chatroom";
	private NEResquester requester;

	/**
	 * 创建聊天室
	 * @param creator 聊天室属主的账号accid（必须）
	 * @param name 聊天室名称，长度限制128个字符（必须）
	 * @param announcement 公告，长度限制4096个字符（可选）
	 * @param broadcasturl 直播地址，长度限制1024个字符（可选）
	 * @param ext 扩展字段，最长4096字符（可选）
	 * @return
	 */
	public NEIMChatroom createRoom(String creator, String name, String announcement, String broadcasturl, String ext) {
		if (creator == null) {
			throw new IllegalArgumentException("creator不能为空");
		}
		if (name == null) {
			throw new IllegalArgumentException("name不能为空");
		}
		if (name.length() > 128) {
			throw new IllegalArgumentException("聊天室名称长度限制128个字符");
		}
		if (announcement != null && announcement.length() > 4096) {
			throw new IllegalArgumentException("公告长度限制4096个字符");
		}
		if (broadcasturl != null && broadcasturl.length() > 1024) {
			throw new IllegalArgumentException("直播地址长度限制1024个字符");
		}
		if (ext != null && ext.length() > 4096) {
			throw new IllegalArgumentException("扩展字段最长4096字符");
		}
		// build参数集合
		List<NameValuePair> nvps = NameValuePairBuilder.newBuilder()
				.addParam("creator", creator)
				.addParam("name", name)
				.addParam("announcement", announcement)
				.addParam("broadcasturl", broadcasturl)
				.addParam("ext", ext).getParams();


		JSONObject jsonObject = requester.getJSONObjectOnly200ElseError(USER_BASE_URL + "/create.action", nvps);
		if (jsonObject == null) {
			return null;
		}

		JSONObject info = jsonObject.getJSONObject("chatroom");
		NEIMChatroom room = new NEIMChatroom();
		room.setRoomid(info.getInteger("roomid"));
		room.setValid(info.getBoolean("valid"));
		room.setAnnouncement(info.getString("announcement"));
		room.setName(info.getString("name"));
		room.setBroadcasturl(info.getString("broadcasturl"));
		room.setExt(info.getString("ext"));
		room.setCreator(info.getString("creator"));

		return room;
	}


	public NEResquester getRequester() {
		return requester;
	}

	public void setRequester(NEResquester requester) {
		this.requester = requester;
	}
}
