package com.zthzinfo.sdks.netease.im.vo;

import com.alibaba.fastjson.JSONObject;

/**
 * 用户相关实体类
 * Created by sunzsh on 2016/12/15.
 */
public class NEIMUser {
    public NEIMUser(){ }

    public NEIMUser(JSONObject jo) {
        if (jo == null) {
            return;
        }
        this.setToken(jo.getString("token"));
        this.setAccid(jo.getString("accid"));
        this.setName(jo.getString("name"));
        this.setSign(jo.getString("sign"));
        this.setEmail(jo.getString("email"));
        this.setBirth(jo.getString("birth"));
        this.setMobile(jo.getString("mobile"));
        this.setGender(jo.getString("gender"));
        this.setEx(jo.getString("ex"));
    }

    private String token;   // 用户密码
    private String accid;   // 用户帐号，最大长度32字符，必须保证一个APP内唯一
    private String name;    // 用户昵称，最大长度64字符
    private String sign;    // 用户签名，最大长度256字符
    private String email;   // 用户email，最大长度64字符
    private String birth;   // 用户生日，最大长度16字符
    private String mobile;  // 用户mobile，最大长度32字符，只支持国内号码
    private String gender;  // 用户性别，0表示未知，1表示男，2女表示女，其它会报参数错误
    private String ex;      // 用户名片扩展字段，最大长度1024字符，用户可自行扩展，建议封装成JSON字符串

    /**
     * 用户密码
     */
    public String getToken() {
        return token;
    }

    /**
     * 用户密码
     */
    public void setToken(String token) {
        this.token = token;
    }

    /**
     * 用户帐号，最大长度32字符，必须保证一个APP内唯一
     */
    public String getAccid() {
        return accid;
    }

    /**
     * 用户帐号，最大长度32字符，必须保证一个APP内唯一
     */
    public void setAccid(String accid) {
        this.accid = accid;
    }

    /**
     * 用户昵称，最大长度64字符
     */
    public String getName() {
        return name;
    }

    /**
     * 用户昵称，最大长度64字符
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 用户签名，最大长度256字符
     */
    public String getSign() {
        return sign;
    }

    /**
     * 用户签名，最大长度256字符
     */
    public void setSign(String sign) {
        this.sign = sign;
    }

    /**
     * 用户email，最大长度64字符
     */
    public String getEmail() {
        return email;
    }

    /**
     * 用户email，最大长度64字符
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 用户生日，最大长度16字符
     */
    public String getBirth() {
        return birth;
    }

    /**
     * 用户生日，最大长度16字符
     */
    public void setBirth(String birth) {
        this.birth = birth;
    }

    /**
     * 用户mobile，最大长度32字符，只支持国内号码
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * 用户mobile，最大长度32字符，只支持国内号码
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * 用户性别，0表示未知，1表示男，2女表示女，其它会报参数错误
     */
    public String getGender() {
        return gender;
    }

    /**
     * 用户性别，0表示未知，1表示男，2女表示女，其它会报参数错误
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /**
     * 用户名片扩展字段，最大长度1024字符，用户可自行扩展，建议封装成JSON字符串
     */
    public String getEx() {
        return ex;
    }

    /**
     * 用户名片扩展字段，最大长度1024字符，用户可自行扩展，建议封装成JSON字符串
     */
    public void setEx(String ex) {
        this.ex = ex;
    }
}
