package com.zthzinfo.sdks.netease.sms.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NEResquester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.sms.bean.NEMsgTemplate;
import com.zthzinfo.sdks.netease.sms.vo.NESMSResult;
import com.zthzinfo.sdks.netease.sms.vo.NESMSStatus;
import org.apache.http.NameValuePair;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 发送模板短信相关
 * Created by yanghb on 16/12/16.
 */
public class NESMSService {

	private static final String SMS_BASE_URL = NEResquester.BASE_URL + "/sms";
	private NEResquester requester;

	/**
	 * 发送模板短信
	 *
	 * @param templateId 模板编号(由客户顾问配置之后告知开发者)
	 * @param mobiles    接收者号码列表，字符串数组格式,如{“186XXXXXXXX”，“177XXXXXXX”}，限制接收者号码个数最多为100个
	 * @param params     短信参数列表，用于依次填充模板，字符串数组格式，如{“XXX”，“XXX”};对于不包含变量的模板，不填此参数表示模板即短信全文内容
	 * @return Long         发送短信的编号sendid 短信发送之后返回的编号  用于短信发送状态查询
	 */
	private Long sendTemplateMsg(Long templateId, String[] mobiles, String[] params) {
		if (templateId == null) {
			throw new IllegalArgumentException("templateId不能为空");
		}
		if (mobiles == null || mobiles.length == 0 || mobiles.length > 100) {
			throw new IllegalArgumentException("mobiles 数量介于1到100个之间");
		}
		String mobilesString = (new JSONArray((Arrays.<Object>asList(mobiles)))).toJSONString();


		String paramsString = null;
		if (params != null) {
			paramsString = (new JSONArray(Arrays.<Object>asList(params))).toJSONString();
		}
		// build参数集合
		List<NameValuePair> nvps1 = NameValuePairBuilder.newBuilder()
				.addParam("templateid", templateId.toString())
				.addParam("mobiles", mobilesString)
				.addParam("params", paramsString).getParams();
		/** 发送模板短信 **/
		JSONObject sendObject = requester.getJSONObjectOnly200(SMS_BASE_URL + "/sendtemplate.action", nvps1);
		if (sendObject == null) {
			return null;
		}
		Long sendId = sendObject.getLong("obj");
		if (sendId == null) {
			return null;
		}
		return sendId;
	}

	/**
	 * 查询模板短信发送状态
	 *
	 * @param sendId 发送的sendid 短信发送之后
	 * @return NESMSResult
	 */
	public NESMSResult queryTemplateMsgStatus(Long sendId) {
		if (sendId == null) {
			throw new IllegalArgumentException("sendId不能为空");
		}
		List<NameValuePair> nvps = NameValuePairBuilder.newBuilder().addParam("sendid", sendId.toString()).getParams();
		/** 发送模板短信 **/
		JSONObject queryObject = requester.getJSONObjectOnly200(SMS_BASE_URL + "/querystatus.action", nvps);
		if (queryObject == null) {
			return null;
		}
		JSONArray statusJSONArray = queryObject.getJSONArray("obj");
		if (statusJSONArray == null || statusJSONArray.size() == 0) {
			return null;
		}
		List<NESMSStatus> statusList = new ArrayList<NESMSStatus>();
		for (Object statusObject : statusJSONArray) {
			JSONObject statusJson = (JSONObject) statusObject;
			NESMSStatus status = new NESMSStatus(statusJson);
			statusList.add(status);
		}
		return new NESMSResult(sendId, statusList);
	}

	/**
	 * 发送模板短信
	 *
	 * @param neMsgTemplate 模板短信参数接口  模板编号(由客户顾问配置之后告知开发者)
	 * @param mobiles     接收者号码列表，字符串数组格式,如{“186XXXXXXXX”，“177XXXXXXX”}，限制接收者号码个数最多为100个
	 * @return NESMSResult
	 */
	public Long sendTemplateMsg(NEMsgTemplate neMsgTemplate, String... mobiles) {
		return sendTemplateMsg(neMsgTemplate.getTemplateId(), mobiles, neMsgTemplate.getTemplateParams());
	}

	public NEResquester getRequester() {
		return requester;
	}

	public void setRequester(NEResquester requester) {
		this.requester = requester;
	}
}
