/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.sdks.netease.im.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NERequester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.im.vo.NEIMUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;

public class NEIMUserService {
    private static final String USER_BASE_URL = "https://api.netease.im/nimserver/user";
    private NERequester requester;

    public NEIMUser createUser(String accid, String token, String name, String jsonProps, String headerIcon) {
        List<NameValuePair> nvps;
        JSONObject jsonObject;
        if (accid == null) {
            throw new IllegalArgumentException("accid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (jsonProps != null) {
            if (jsonProps.length() > 1024) {
                throw new IllegalArgumentException("jsonProps\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71024");
            }
            try {
                JSON.parseObject((String)jsonProps);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("jsonProps\u4e0d\u662f\u6709\u6548\u7684JsonObject\u683c\u5f0f");
            }
        }
        if ((jsonObject = this.requester.getJSONObjectOnly200("https://api.netease.im/nimserver/user/create.action", nvps = NameValuePairBuilder.newBuilder().addParam("accid", accid).addParam("token", token).addParam("name", name).addParam("props", jsonProps).addParam("icon", headerIcon).getParams())) == null) {
            return null;
        }
        JSONObject info = jsonObject.getJSONObject("info");
        NEIMUser user = new NEIMUser();
        user.setAccid(info.getString("accid"));
        user.setToken(info.getString("token"));
        user.setName(info.getString("name"));
        return user;
    }

    public NEIMUser getUserInfo(String accid) {
        if (accid == null) {
            return null;
        }
        List<NEIMUser> list = this.getUserInfos(new String[]{accid});
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<NEIMUser> getUserInfos(String[] accids) {
        if (accids == null) {
            return null;
        }
        if (accids.length == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (String accid : accids) {
            ja.add((Object)accid);
        }
        List<NameValuePair> nvps = NameValuePairBuilder.newBuilder().addParam("accids", ja.toJSONString()).getParams();
        JSONObject jo = this.requester.getJSONObjectOnly200("https://api.netease.im/nimserver/user/getUinfos.action", nvps);
        if (jo == null) {
            return null;
        }
        ArrayList<NEIMUser> result = new ArrayList<NEIMUser>();
        JSONArray uinfos = jo.getJSONArray("uinfos");
        if (uinfos == null) {
            return result;
        }
        for (int i = 0; i < uinfos.size(); ++i) {
            JSONObject userJson = uinfos.getJSONObject(i);
            result.add(new NEIMUser(userJson));
        }
        return result;
    }

    public boolean updateUserInfo(String accid, String jsonProps, String token) {
        List<NameValuePair> nvps;
        JSONObject jsonObject;
        if (accid == null) {
            throw new IllegalArgumentException("accid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (jsonProps != null) {
            if (jsonProps.length() > 1024) {
                throw new IllegalArgumentException("jsonProps\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71024");
            }
            try {
                JSON.parseObject((String)jsonProps);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("jsonProps\u4e0d\u662f\u6709\u6548\u7684JsonObject\u683c\u5f0f");
            }
        }
        return (jsonObject = this.requester.getJSONObjectOnly200("https://api.netease.im/nimserver/user/update.action", nvps = NameValuePairBuilder.newBuilder().addParam("accid", accid).addParam("token", token).addParam("props", jsonProps).getParams())) != null;
    }

    public NERequester getRequester() {
        return this.requester;
    }

    public void setRequester(NERequester requester) {
        this.requester = requester;
    }
}

