/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.sdks.netease.sms.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NERequester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.sms.bean.NEMsgTemplate;
import com.zthzinfo.sdks.netease.sms.vo.NESMSResult;
import com.zthzinfo.sdks.netease.sms.vo.NESMSStatus;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.http.NameValuePair;

public class NESMSService {
    private static final String SMS_BASE_URL = "https://api.netease.im/sms";
    private NERequester requester;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private Long sendTemplateMsg(Long templateId, String[] mobiles, String[] params) {
        if (templateId == null) {
            throw new IllegalArgumentException("templateId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mobiles == null || mobiles.length == 0 || mobiles.length > 100) {
            throw new IllegalArgumentException("mobiles \u6570\u91cf\u4ecb\u4e8e1\u5230100\u4e2a\u4e4b\u95f4");
        }
        String mobilesString = new JSONArray(Arrays.asList(mobiles)).toJSONString();
        String paramsString = null;
        if (params != null) {
            paramsString = new JSONArray(Arrays.asList(params)).toJSONString();
        }
        System.out.println(String.format("\u3010\u53d1\u9001\u7f51\u6613\u77ed\u4fe1\u3011%s:[%s],(%s),(%s)", templateId + "", this.sdf.format(new Date()), mobilesString, paramsString));
        List<NameValuePair> nvps1 = NameValuePairBuilder.newBuilder().addParam("templateid", templateId.toString()).addParam("mobiles", mobilesString).addParam("params", paramsString).getParams();
        JSONObject sendObject = this.requester.getJSONObjectOnly200("https://api.netease.im/sms/sendtemplate.action", nvps1);
        if (sendObject == null) {
            return null;
        }
        Long sendId = sendObject.getLong("obj");
        if (sendId == null) {
            return null;
        }
        return sendId;
    }

    public NESMSResult queryTemplateMsgStatus(Long sendId) {
        if (sendId == null) {
            throw new IllegalArgumentException("sendId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<NameValuePair> nvps = NameValuePairBuilder.newBuilder().addParam("sendid", sendId.toString()).getParams();
        JSONObject queryObject = this.requester.getJSONObjectOnly200("https://api.netease.im/sms/querystatus.action", nvps);
        if (queryObject == null) {
            return null;
        }
        JSONArray statusJSONArray = queryObject.getJSONArray("obj");
        if (statusJSONArray == null || statusJSONArray.size() == 0) {
            return null;
        }
        ArrayList<NESMSStatus> statusList = new ArrayList<NESMSStatus>();
        for (Object statusObject : statusJSONArray) {
            JSONObject statusJson = (JSONObject)statusObject;
            NESMSStatus status = new NESMSStatus(statusJson);
            statusList.add(status);
        }
        return new NESMSResult(sendId, statusList);
    }

    public Long sendTemplateMsg(NEMsgTemplate neMsgTemplate, String ... mobiles) {
        return this.sendTemplateMsg(neMsgTemplate.getTemplateId(), mobiles, neMsgTemplate.getTemplateParams());
    }

    public NERequester getRequester() {
        return this.requester;
    }

    public void setRequester(NERequester requester) {
        this.requester = requester;
    }
}

