/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.sdks.netease.im.service;

import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.sdks.netease.common.utils.NERequester;
import com.zthzinfo.sdks.netease.common.utils.NameValuePairBuilder;
import com.zthzinfo.sdks.netease.im.vo.NEIMChatroom;
import java.util.List;
import org.apache.http.NameValuePair;

public class NEIMChatroomService {
    private static final String USER_BASE_URL = "https://api.netease.im/nimserver/chatroom";
    private NERequester requester;

    public NEIMChatroom createRoom(String creator, String name, String announcement, String broadcasturl, String ext) {
        if (creator == null) {
            throw new IllegalArgumentException("creator\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (name == null) {
            throw new IllegalArgumentException("name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (name.length() > 128) {
            throw new IllegalArgumentException("\u804a\u5929\u5ba4\u540d\u79f0\u957f\u5ea6\u9650\u5236128\u4e2a\u5b57\u7b26");
        }
        if (announcement != null && announcement.length() > 4096) {
            throw new IllegalArgumentException("\u516c\u544a\u957f\u5ea6\u9650\u52364096\u4e2a\u5b57\u7b26");
        }
        if (broadcasturl != null && broadcasturl.length() > 1024) {
            throw new IllegalArgumentException("\u76f4\u64ad\u5730\u5740\u957f\u5ea6\u9650\u52361024\u4e2a\u5b57\u7b26");
        }
        if (ext != null && ext.length() > 4096) {
            throw new IllegalArgumentException("\u6269\u5c55\u5b57\u6bb5\u6700\u957f4096\u5b57\u7b26");
        }
        List<NameValuePair> nvps = NameValuePairBuilder.newBuilder().addParam("creator", creator).addParam("name", name).addParam("announcement", announcement).addParam("broadcasturl", broadcasturl).addParam("ext", ext).getParams();
        JSONObject jsonObject = this.requester.getJSONObjectOnly200ElseError("https://api.netease.im/nimserver/chatroom/create.action", nvps);
        if (jsonObject == null) {
            return null;
        }
        JSONObject info = jsonObject.getJSONObject("chatroom");
        NEIMChatroom room = new NEIMChatroom();
        room.setRoomid(info.getInteger("roomid"));
        room.setValid(info.getBoolean("valid"));
        room.setAnnouncement(info.getString("announcement"));
        room.setName(info.getString("name"));
        room.setBroadcasturl(info.getString("broadcasturl"));
        room.setExt(info.getString("ext"));
        room.setCreator(info.getString("creator"));
        return room;
    }

    public NEIMChatroom toggleCloseStat(String creator, Integer roomid, boolean valid) {
        if (creator == null) {
            throw new IllegalArgumentException("creator\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (roomid == null) {
            throw new IllegalArgumentException("roomid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<NameValuePair> nvps = NameValuePairBuilder.newBuilder().addParam("operator", creator).addParam("roomid", roomid + "").addParam("valid", valid ? "true" : "false").getParams();
        JSONObject jsonObject = this.requester.getJSONObjectOnly200ElseError("https://api.netease.im/nimserver/chatroom/toggleCloseStat.action", nvps);
        if (jsonObject == null) {
            return null;
        }
        JSONObject info = jsonObject.getJSONObject("desc");
        NEIMChatroom room = new NEIMChatroom();
        room.setRoomid(info.getInteger("roomid"));
        room.setValid(info.getBoolean("valid"));
        room.setAnnouncement(info.getString("announcement"));
        room.setName(info.getString("name"));
        room.setBroadcasturl(info.getString("broadcasturl"));
        room.setExt(info.getString("ext"));
        room.setCreator(info.getString("creator"));
        return room;
    }

    public NERequester getRequester() {
        return this.requester;
    }

    public void setRequester(NERequester requester) {
        this.requester = requester;
    }
}

