/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.FilePostParam;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class CKFAliyunDeleteFilesCommand
extends XMLCommand
implements IPostCommand {
    private List<FilePostParam> files;
    private int filesDeleted;
    private boolean addDeleteNode;
    private String buket_key;
    private String userId;

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (this.creator.hasErrors()) {
            Element errorsNode = this.creator.getDocument().createElement("Errors");
            this.creator.addErrors(errorsNode);
            rootElement.appendChild(errorsNode);
        }
        if (this.addDeleteNode) {
            this.createDeleteFielsNode(rootElement);
        }
    }

    private void createDeleteFielsNode(Element rootElement) {
        Element element = this.creator.getDocument().createElement("DeleteFiles");
        element.setAttribute("deleted", String.valueOf(this.filesDeleted));
        rootElement.appendChild(element);
    }

    protected int getDataForXml() {
        this.filesDeleted = 0;
        this.addDeleteNode = false;
        for (FilePostParam fileItem : this.files) {
            if (!FileUtils.checkFileName((String)fileItem.getName())) {
                return 109;
            }
            if (this.configuration.getTypes().get(fileItem.getType()) == null) {
                return 109;
            }
            if (fileItem.getFolder() == null || fileItem.getFolder().equals("") || Pattern.compile("(/\\.|\\p{Cntrl}|//|\\\\|[:*?<>\"\\|])").matcher(fileItem.getFolder()).find()) {
                return 109;
            }
            if (FileUtils.checkIfDirIsHidden((String)fileItem.getFolder(), (IConfiguration)this.configuration)) {
                return 109;
            }
            if (FileUtils.checkIfFileIsHidden((String)fileItem.getName(), (IConfiguration)this.configuration)) {
                return 109;
            }
            if (FileUtils.checkFileExtension((String)fileItem.getName(), (ResourceType)((ResourceType)this.configuration.getTypes().get(fileItem.getType())), (IConfiguration)this.configuration, (boolean)false) == 1) {
                return 109;
            }
            if (!AccessControlUtil.getInstance((IConfiguration)this.configuration).checkFolderACL(fileItem.getType(), fileItem.getFolder(), this.userRole, 128)) {
                return 103;
            }
            File file = new File(((ResourceType)this.configuration.getTypes().get(fileItem.getType())).getPath() + fileItem.getFolder(), fileItem.getName());
            try {
                this.addDeleteNode = true;
                SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
                Map types = this.configuration.getTypes();
                String typeName = ((ResourceType)types.get(this.type)).getName();
                if (OSSObjectTool.isExists(this.buket_key == null || this.buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : this.buket_key, this.userId == null || this.userId.trim().equals("") ? principal.getId() : this.userId + "/" + typeName + this.currentFolder + fileItem.getName()).booleanValue()) {
                    OSSObjectTool.delFile(this.buket_key == null || this.buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : this.buket_key, this.userId == null || this.userId.trim().equals("") ? principal.getId() : this.userId + "/" + typeName + this.currentFolder + fileItem.getName());
                    continue;
                }
                this.creator.appendErrorNodeChild(117, fileItem.getName(), fileItem.getFolder(), fileItem.getType());
            }
            catch (SecurityException var7) {
                if (this.configuration.isDebugMode()) {
                    throw var7;
                }
                return 104;
            }
        }
        if (this.creator.hasErrors()) {
            return 302;
        }
        return 0;
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, new Object[0]);
        this.files = new ArrayList<FilePostParam>();
        this.getFilesListFromRequest(request);
    }

    private void getFilesListFromRequest(HttpServletRequest request) {
        int i = 0;
        String paramName = "files[" + i + "][name]";
        while (request.getParameter(paramName) != null) {
            FilePostParam file = new FilePostParam();
            file.setName(this.getParameter(request, paramName));
            file.setFolder(this.getParameter(request, "files[" + i + "][folder]"));
            file.setOptions(this.getParameter(request, "files[" + i + "][options]"));
            file.setType(this.getParameter(request, "files[" + i + "][type]"));
            this.files.add(file);
            StringBuilder var10000 = new StringBuilder().append("files[");
            paramName = var10000.append(++i).append("][name]").toString();
        }
    }

    protected boolean checkIfCurrFolderExists(HttpServletRequest request) throws ConnectorException {
        return true;
    }

    public String getBuket_key() {
        return this.buket_key;
    }

    public void setBuket_key(String buket_key) {
        this.buket_key = buket_key;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

